/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.discordipc.entities.pipe;

import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.IPCListener;
import com.jagrosh.discordipc.entities.DiscordBuild;
import com.jagrosh.discordipc.entities.Packet;
import com.jagrosh.discordipc.entities.User;
import com.jagrosh.discordipc.entities.pipe.PipeStatus;
import com.jagrosh.discordipc.entities.pipe.UnixPipe;
import com.jagrosh.discordipc.entities.pipe.WindowsPipe;
import com.jagrosh.discordipc.entities.pipe.listener.PipeCreationListener;
import com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import java.io.IOException;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Pipe {
    private static final int VERSION = 1;
    private static final String[] unixPaths = new String[]{"XDG_RUNTIME_DIR", "TMPDIR", "TMP", "TEMP"};
    final IPCClient ipcClient;
    PipeStatus status = PipeStatus.CONNECTING;
    IPCListener listener;
    private DiscordBuild build;

    Pipe(IPCClient ipcClient) {
        this.ipcClient = ipcClient;
    }

    public static Pipe openPipe(IPCClient ipcClient, PipeCreationListener pipeCreationListener, long clientId, DiscordBuild ... preferredOrder) throws NoDiscordClientException {
        int i;
        if (preferredOrder == null || preferredOrder.length == 0) {
            preferredOrder = new DiscordBuild[]{DiscordBuild.ANY};
        }
        Pipe pipe = null;
        Pipe[] open = new Pipe[DiscordBuild.values().length];
        for (i = 0; i < 10; ++i) {
            try {
                String location = Pipe.getPipeLocation(i);
                pipe = Pipe.createPipe(ipcClient, location);
                pipe.send(Packet.OpCode.HANDSHAKE, new JSONObject().put("v", 1).put("client_id", Long.toString(clientId)));
                Packet p = pipe.read();
                JSONObject data = p.getJson().getJSONObject("data");
                JSONObject userObject = data.getJSONObject("user");
                pipe.build = DiscordBuild.from(data.getJSONObject("config").getString("api_endpoint"));
                if (pipe.build == preferredOrder[0] || DiscordBuild.ANY == preferredOrder[0]) {
                    pipeCreationListener.onUserFound(new User(userObject.getString("username"), userObject.getString("discriminator"), Long.parseLong(userObject.getString("id")), userObject.optString("avatar", null)));
                    break;
                }
                open[pipe.build.ordinal()] = pipe;
                open[DiscordBuild.ANY.ordinal()] = pipe;
                pipe.build = null;
                pipe = null;
                continue;
            }
            catch (IOException | RuntimeException ignored) {
                pipe = null;
            }
        }
        if (pipe == null) {
            for (i = 1; i < preferredOrder.length; ++i) {
                DiscordBuild cb = preferredOrder[i];
                if (open[cb.ordinal()] == null) continue;
                pipe = open[cb.ordinal()];
                open[cb.ordinal()] = null;
                if (cb == DiscordBuild.ANY) {
                    for (int k = 0; k < open.length; ++k) {
                        if (open[k] != pipe) continue;
                        pipe.build = DiscordBuild.values()[k];
                        open[k] = null;
                    }
                    break;
                }
                pipe.build = cb;
                break;
            }
            if (pipe == null) {
                throw new NoDiscordClientException();
            }
        }
        for (i = 0; i < open.length; ++i) {
            if (i == DiscordBuild.ANY.ordinal() || open[i] == null) continue;
            try {
                open[i].close();
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        pipe.status = PipeStatus.CONNECTED;
        return pipe;
    }

    private static Pipe createPipe(IPCClient ipcClient, String location) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return new WindowsPipe(ipcClient, location);
        }
        if (osName.contains("linux") || osName.contains("mac")) {
            try {
                return new UnixPipe(ipcClient, location);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unsupported OS: " + osName);
    }

    private static String generateNonce() {
        return UUID.randomUUID().toString();
    }

    private static String getPipeLocation(int i) {
        String str;
        if (System.getProperty("os.name").contains("Win")) {
            return "\\\\?\\pipe\\discord-ipc-" + i;
        }
        String tmppath = null;
        String[] stringArray = unixPaths;
        int n = stringArray.length;
        for (int j = 0; j < n && (tmppath = System.getenv(str = stringArray[j])) == null; ++j) {
        }
        if (tmppath == null) {
            tmppath = "/tmp";
        }
        return tmppath + "/discord-ipc-" + i;
    }

    public void send(Packet.OpCode op, JSONObject data) {
        try {
            String nonce = Pipe.generateNonce();
            Packet p = new Packet(op, data.put("nonce", nonce));
            this.write(p.toBytes());
            if (this.listener != null) {
                this.listener.onPacketSent(this.ipcClient, p);
            }
        }
        catch (IOException ex) {
            this.status = PipeStatus.DISCONNECTED;
        }
    }

    public abstract Packet read() throws IOException, JSONException;

    public abstract void write(byte[] var1) throws IOException;

    public PipeStatus getStatus() {
        return this.status;
    }

    public void setStatus(PipeStatus status) {
        this.status = status;
    }

    public void setListener(IPCListener listener) {
        this.listener = listener;
    }

    public abstract void close() throws IOException;

    public DiscordBuild getDiscordBuild() {
        return this.build;
    }
}

